---
title: Traditional function calling · Cloudflare Workers AI docs
description: This page shows how you can do traditional function calling, as
  defined by industry standards. Workers AI also offers embedded function
  calling, which is drastically easier than traditional function calling.
lastUpdated: 2025-04-03T16:21:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers-ai/features/function-calling/traditional/
  md: https://developers.cloudflare.com/workers-ai/features/function-calling/traditional/index.md
---

This page shows how you can do traditional function calling, as defined by industry standards. Workers AI also offers [embedded function calling](https://developers.cloudflare.com/workers-ai/features/function-calling/embedded/), which is drastically easier than traditional function calling.

With traditional function calling, you define an array of tools with the name, description, and tool arguments. The example below shows how you would pass a tool called `getWeather` in an inference request to a model.

```js
const response = await env.AI.run("@hf/nousresearch/hermes-2-pro-mistral-7b", {
  messages: [
    {
      role: "user",
      content: "what is the weather in london?",
    },
  ],
  tools: [
    {
      name: "getWeather",
      description: "Return the weather for a latitude and longitude",
      parameters: {
        type: "object",
        properties: {
          latitude: {
            type: "string",
            description: "The latitude for the given location",
          },
          longitude: {
            type: "string",
            description: "The longitude for the given location",
          },
        },
        required: ["latitude", "longitude"],
      },
    },
  ],
});


return new Response(JSON.stringify(response.tool_calls));
```

The LLM will then return a JSON object with the required arguments and the name of the tool that was called. You can then pass this JSON object to make an API call.

```json
[
  {
    "arguments": { "latitude": "51.5074", "longitude": "-0.1278" },
    "name": "getWeather"
  }
]
```

For a working example on how to do function calling, take a look at our [demo app](https://github.com/craigsdennis/lightbulb-moment-tool-calling/blob/main/src/index.ts).
