---
title: Deploy to Cloudflare buttons now support Worker environment variables,
  secrets, and Secrets Store secrets · Changelog
description: Worker environment variables, secrets, and Secrets Store secrets
  can now be used in Workers templates
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-07-01-workers-deploy-button-supports-environment-variables-and-secrets/
  md: https://developers.cloudflare.com/changelog/2025-07-01-workers-deploy-button-supports-environment-variables-and-secrets/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Deploy to Cloudflare buttons now support Worker environment variables, secrets, and Secrets Store secrets

Jul 29, 2025

[Workers ](https://developers.cloudflare.com/workers/)[Secrets Store](https://developers.cloudflare.com/secrets-store/)

Any template which uses [Worker environment variables](https://developers.cloudflare.com/workers/configuration/environment-variables/), [secrets](https://developers.cloudflare.com/workers/configuration/secrets/), or [Secrets Store secrets](https://developers.cloudflare.com/secrets-store/) can now be deployed using a [Deploy to Cloudflare button](https://developers.cloudflare.com/workers/platform/deploy-buttons/).

Define environment variables and secrets store bindings in your Wrangler configuration file as normal:

* wrangler.jsonc

  ```jsonc
  {
    "name": "my-worker",
    "main": "./src/index.ts",
    "compatibility_date": "2025-11-08",
    "vars": {
      "API_HOST": "https://example.com",
    },
    "secrets_store_secrets": [
      {
        "binding": "API_KEY",
        "store_id": "demo",
        "secret_name": "api-key"
      }
    ]
  }
  ```

* wrangler.toml

  ```toml
  name = "my-worker"
  main = "./src/index.ts"
  compatibility_date = "2025-11-08"


  [vars]
  API_HOST = "https://example.com"


  [[secrets_store_secrets]]
  binding = "API_KEY"
  store_id = "demo"
  secret_name = "api-key"
  ```

Add secrets to a `.dev.vars.example` or `.env.example` file:

```ini
COOKIE_SIGNING_KEY=my-secret # comment
```

And optionally, you can add a description for these bindings in your template's `package.json` to help users understand how to configure each value:

```json
{
  "name": "my-worker",
  "private": true,
  "cloudflare": {
    "bindings": {
      "API_KEY": {
        "description": "Select your company's API key for connecting to the example service."
      },
      "COOKIE_SIGNING_KEY": {
        "description": "Generate a random string using `openssl rand -hex 32`."
      }
    }
  }
}
```

These secrets and environment variables will be presented to users in the dashboard as they deploy this template, allowing them to configure each value. Additional information about creating templates and Deploy to Cloudflare buttons can be found in [our documentation](https://developers.cloudflare.com/workers/platform/deploy-buttons/).
